/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.pdraw.util.GridIfc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class GridPanel
extends DataInputPanel {
    private JCheckBox fCbxGridAttraction;
    private JCheckBox fCbxGridConnectionAttraction;
    private JCheckBox fCbxGridVisibility;
    private JCheckBox fCbxUseAsDefault;
    private EditableNumericSpinner fSpinnerGridDistance;
    private JLabel fLblGridDistance;
    private GridIfc fModel;

    public GridPanel(GridIfc gridIfc) {
        this.fModel = gridIfc;
        this.initialize();
    }

    public boolean checkFieldContents() {
        if (!this.fSpinnerGridDistance.checkValue(false)) {
            this.fSpinnerGridDistance.requestFocus();
            return false;
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(275, 155);
    }

    public String getTitle() {
        return Language.getString("dialog.grid.title", "Grid");
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fLblGridDistance = new JLabel("Grid distance");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.fLblGridDistance, gbc);
        this.fSpinnerGridDistance = new EditableNumericSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fSpinnerGridDistance, gbc);
        this.fCbxGridAttraction = new JCheckBox("Attraction");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.fCbxGridAttraction, gbc);
        this.fCbxGridConnectionAttraction = new JCheckBox("ConnectionAttraction");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.add((Component)this.fCbxGridConnectionAttraction, gbc);
        this.fCbxGridVisibility = new JCheckBox("Visibility");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.add((Component)this.fCbxGridVisibility, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.fCbxUseAsDefault = new JCheckBox("Use as default");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(20, 0, 0, 0);
        gbc.anchor = 17;
        this.add((Component)this.fCbxUseAsDefault, gbc);
    }

    public void loadFieldContents() {
        this.fSpinnerGridDistance.setMax(100);
        this.fSpinnerGridDistance.setMin(5);
        this.fSpinnerGridDistance.setIncrement(5);
        this.fSpinnerGridDistance.setValue(this.fModel.getDistance());
        this.fCbxGridAttraction.setSelected(this.fModel.gridAttractionIsOn());
        this.fCbxGridConnectionAttraction.setSelected(this.fModel.gridConnectionAttractionIsOn());
        this.fCbxGridVisibility.setSelected(this.fModel.gridIsVisible());
    }

    public void setLabels() {
        this.fCbxGridAttraction.setText(Language.getString("dialog.grid.attraction", "Attraction"));
        this.fCbxGridConnectionAttraction.setText(Language.getString("dialog.grid.connectionAttraction", "ConnectionAttraction"));
        this.fCbxGridVisibility.setText(Language.getString("dialog.grid.visibility", "Visibility"));
        this.fLblGridDistance.setText(Language.getString("dialog.grid.horizontal", "Distance(Points):"));
        Object[] values = new Object[]{new Integer(5), new Integer(100), new Integer(5)};
        this.fSpinnerGridDistance.setError(new LogoError((Component)this.fSpinnerGridDistance, "error.dialog.invalidValueIncrement", "Please enter an integer between 5 and 100 in the distance of 5", values, 2, 0));
        this.fCbxUseAsDefault.setText(Language.getString("dialog.useAsDefault"));
    }

    public void storeFieldContents() {
        this.fModel.setDistance(this.fSpinnerGridDistance.getValue());
        this.fModel.setGridAttraction(this.fCbxGridAttraction.isSelected());
        this.fModel.setGridConnectionAttraction(this.fCbxGridConnectionAttraction.isSelected());
        this.fModel.setGridVisibility(this.fCbxGridVisibility.isSelected());
        Application.getInstance().getActiveApplicationSurface().repaint();
        if (this.fCbxUseAsDefault.isSelected()) {
            this.fModel.saveAsDefault();
        }
    }
}

